<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Galeria obrazów</title>
  </head>
  <body>
    <?php
    $imgDir = "./images";

    //Odczytanie parametru
    if(isSet($_GET['imgid'])){
      $imgId = (int) $_GET['imgid'];
    }
    else{
      $imgId = 0;
    }

    //Odczytanie zawartości katalogu
    $dir = scandir($imgDir);

    foreach($dir as $key => $val){
      if(!is_file("$imgDir/$val")){
        unset($dir[$key]);
        continue;
      }
      
      $ext = substr($val, count($val) - 5, 5);
      $ext = strtolower($ext);
      
      if($ext != '.jpg' && $ext != '.gif' && $ext != '.png'){
        unset($dir[$key]);
        continue;
      }
    }

    sort($dir);

    $count = count($dir);

    if($count < 1){
      echo "<p style=\"text-align:center\">Brak obrazów w galerii.</p>";
      echo "</body></html>";
      exit();
    }

    //Sprawdzenie poprawności parametru
    if($imgId < 0 || $imgId >= $count){
      $imgId = 0;
    }

    //Ustalenie nazwy bieżacego obrazu oraz
    //identyfikatorów obrazów dla odnośników

    $imgName = $dir["$imgId"];

    $first = 0;
    $last = $count - 1;
    if($imgId < $count - 1){
      $next = $imgId + 1;
    }
    else{
      $next = $count - 1;
    }

    if($imgId > 0){
      $prev = $imgId - 1;
    }
    else{
      $prev = 0;
    }
    ?>
    <div>
    <div id='obraz' style='text-align:center'>
    <?php
      echo "<img src=\"$imgDir/$imgName\" alt=\"$imgName\">";
    ?>
    </div>
    <div id='opis' style='text-align:center'>
    <?php 
      $imgId++;
      echo "Obraz $imgName ($imgId z $count)"; 
    ?>
    </div>
    <div id='nawigacja' style='text-align:center'>
    <?php 
      echo "<a href=\"galeria.php?imgid=$first\">Pierwszy</a> ";
      echo "<a href=\"galeria.php?imgid=$prev\">Poprzedni</a> ";
      echo "<a href=\"galeria.php?imgid=$next\">Następny</a> ";
      echo "<a href=\"galeria.php?imgid=$last\">Ostatni</a> ";
    ?>
    </div>
    </div>
  </body>
</html>